#include <windows.h>
#include "z64.h"
#include "Gfx #1.3.h"
#include "vi.h"
#include "rdp.h"
#include "bitmap.h"

HGLRC render_context;
HDC device_context;

HRESULT res;
RECT dst, src;
INT32 pitchindwords;

BOOL emulation_running = FALSE;

const PIXELFORMATDESCRIPTOR pixel_format = {
    sizeof(PIXELFORMATDESCRIPTOR), /* nSize */
    0x0001, /* nVersion */
    PFD_DRAW_TO_WINDOW | PFD_SUPPORT_OPENGL | PFD_DEPTH_DONTCARE, /* dwFlags */
    PFD_TYPE_RGBA, /* iPixelType */
    32, /* cColorBits */

    0, 0,
    0, 0,
    0, 0,
    0, 0,

    0,
    0, 0, 0, 0,

    0, /* cDepthBits */
    0, /* cStencilBits */
    0, /* cAuxBuffers */
    PFD_MAIN_PLANE, /* iLayerType */

    0x00, /* bReserved */
    0x00000000, /* dwLayerMask */
    0x00000000, /* dwVisibleMask */
    0x00000000, /* dwDamageMask */
};
static NOINLINE BOOL init_GL_context(HWND hWnd);
static void draw_test_screen(void);

FILE* zeldainfo = 0;
extern int SaveLoaded;
extern UINT32 command_counter;

GFX_INFO gfx;

static char filepath[_MAX_PATH];

EXPORT void CALL CaptureScreen(char * Directory)
{
    static unsigned short count;
    register int i;

    for (i = 0; i < _MAX_PATH; i++)
        if (Directory[i] == '\0')
            break;
        else
            filepath[i] = *(Directory + i);
    if (i + 12 >= _MAX_PATH)
    {
        MessageBox(NULL, "Screenshots directory too long.", NULL, MB_ICONERROR);
        return;
    }
    filepath[i] = GET_GFX_INFO(HEADER)[0x3B ^ BYTE_ADDR_XOR];
    filepath[i++] = (filepath[i] == '\0') ? ' ' : filepath[i];
    filepath[i] = GET_GFX_INFO(HEADER)[0x3C ^ BYTE_ADDR_XOR];
    filepath[i++] = (filepath[i] == '\0') ? ' ' : filepath[i];
    filepath[i] = GET_GFX_INFO(HEADER)[0x3D ^ BYTE_ADDR_XOR];
    filepath[i++] = (filepath[i] == '\0') ? ' ' : filepath[i];
    filepath[i] = GET_GFX_INFO(HEADER)[0x3E ^ BYTE_ADDR_XOR];
    filepath[i++] = (filepath[i] == '\0') ? ' ' : filepath[i];
    filepath[i++] = '0' | (count/1000 % 10);
    filepath[i++] = '0' | (count/ 100 % 10);
    filepath[i++] = '0' | (count/  10 % 10);
    filepath[i++] = '0' | (count/   1 % 10);
    filepath[i++] = '.';
    filepath[i++] = 'b';
    filepath[i++] = 'm';
    filepath[i++] = 'p';
    filepath[i] = '\0';
    capture_screen_to_file[*GET_GFX_INFO(VI_STATUS_REG) & 0x00000001](filepath);
    count = (count + 0x0001) % 10000;
    if (count == 9999)
    {
        MessageBox(
            NULL, "Screenshots directory is about to overflow.", "Warning",
            MB_ICONWARNING);
    }
    return;
}

/*
 * based on the Win32 full-screen implementation written by zilmar in his
 * basic CFB plugin
 */
int is_full_screen = 0;
EXPORT void CALL ChangeWindow(void)
{
    static WINDOWPLACEMENT wndpl;
    static HMENU old_menu;
    static LONG old_style;
    int dimensions[2] = { 0 };
    const HWND hWnd = GET_GFX_INFO(hWnd);
    const HWND hStatusBar = GET_GFX_INFO(hStatusBar);

    if (is_full_screen == 0)
    {
        is_full_screen = 1;
        get_screen_size(dimensions);

        wndpl.length = sizeof(wndpl);
        GetWindowPlacement(hWnd, &wndpl);

        if (hStatusBar)
            ShowWindow(hStatusBar, SW_HIDE);
        old_menu = GetMenu(hWnd);
        if (old_menu)
            SetMenu(hWnd, NULL);
        old_style = GetWindowLong(hWnd, GWL_STYLE);
        SetWindowLong(hWnd, GWL_STYLE, WS_VISIBLE);
        SetWindowPos(
            hWnd, HWND_TOPMOST, 0, 0, dimensions[0], dimensions[1],
            SWP_SHOWWINDOW);
        ShowCursor(FALSE);
    }
    else
    {
        is_full_screen = 0;
        switch (cfg[4])
        {
            case 0x00:
                dimensions[0] = 640;
                dimensions[1] = 480;
                break;
            case 0x01:
                dimensions[0] = hres_old;
                dimensions[1] = vres_old;
                break;
            case 0x02:
                dimensions[0] = (cfg[0] << 8) + cfg[1] + 1;
                dimensions[1] = (cfg[2] << 8) + cfg[3] + 1;
                break;
            default:
                DisplayError("Invalid resolution control setting.");
                break;
        }

        if (hStatusBar)
            ShowWindow(hStatusBar, SW_SHOW);
        if (old_menu)
        { 
            SetMenu(hWnd, old_menu);
            old_menu = NULL;
        }
        SetWindowLong(hWnd, GWL_STYLE, old_style);
        SetWindowPos(
            hWnd, HWND_NOTOPMOST, wndpl.rcNormalPosition.left,
            wndpl.rcNormalPosition.top, dimensions[0], dimensions[1],
            SWP_NOSIZE | SWP_SHOWWINDOW);
        ShowCursor(TRUE);
    }
    sync = TRUE;
    return;
}

EXPORT void CALL CloseDLL(void)
{
    HDC current_DC;
    HGLRC current_RC;

    wglMakeCurrent(device_context, NULL);
    current_DC = wglGetCurrentDC();
    if (current_DC != NULL)
        DisplayError("Failed to free OpenGL render context.");

    wglDeleteContext(render_context);
    current_RC = wglGetCurrentContext();
    if (current_RC != NULL)
        DisplayError("Failed to delete OpenGL render context.");

    ReleaseDC(gfx.hWnd, device_context);
    device_context = NULL;
    render_context = NULL;
    return;
}

EXPORT void CALL ReadScreen(void **dest, long *width, long *height)
{
}

EXPORT void CALL DrawScreen(void)
{
    return;
}

EXPORT void CALL GetDllInfo(PLUGIN_INFO* PluginInfo)
{
    PluginInfo -> Version = 0x0103;
    PluginInfo -> Type  = PLUGIN_TYPE_GFX;
strcpy(
    PluginInfo -> Name, "angrylion's RDP with OpenGL 1.2");
    PluginInfo -> NormalMemory = TRUE;
    PluginInfo -> MemoryBswaped = TRUE;
    return;
}

EXPORT BOOL CALL InitiateGFX(GFX_INFO Gfx_Info)
{
    int DC_released;

    device_context = GetDC(Gfx_Info.hWnd);
    if (device_context == NULL)
    {
        DisplayError("Failed to get device context from render window.");
        return FALSE;
    }

    DC_released = ReleaseDC(Gfx_Info.hWnd, device_context);
    if (DC_released == 0)
    {
        DisplayError("Unable to release initialized device context.");
        return FALSE;
    }
    device_context = NULL;

    emulation_running = FALSE;
 /* RomOpen means emulation started, not InitiateGFX. */

    gfx = Gfx_Info;
#ifdef _DEBUG
    return init_GL_context(Gfx_Info.hWnd);
#else
    return TRUE;
#endif
}

EXPORT void CALL MoveScreen(int xpos, int ypos)
{
    RECT statusrect;
    POINT p;

    p.x = p.y = 0;
    GetClientRect(gfx.hWnd, &dst);
    ClientToScreen(gfx.hWnd, &p);
    OffsetRect(&dst, p.x, p.y);
    GetClientRect(gfx.hStatusBar, &statusrect);
    dst.bottom -= statusrect.bottom;

    sync = TRUE;
    return;
}

EXPORT void CALL ProcessDList(void)
{
    DisplayError("Unidentified microcode."); /* HLE not yet added :P */
    return;
}

EXPORT void CALL ProcessRDPList(void)
{
    process_RDP_list();
    return;
}

EXPORT void CALL RomClosed(void)
{
    emulation_running = FALSE;
    file_out("RDP_CONF.BIN", cfg, 32);
    CloseDLL();

    SaveLoaded = 1;
    command_counter = 0;
    return;
}

GLboolean double_buffering;
EXPORT void CALL RomOpen(void)
{
    BOOL pass;

    rdp_init();
    emulation_running = TRUE;
    sync = TRUE;

    pass = file_in("RDP_CONF.BIN", cfg, 32);
    if (pass == FALSE)
        DisplayError("Could not open `RDP_CONF.BIN'.");
    return;
}

EXPORT void CALL ShowCFB(void)
{
    UpdateScreen();
    return;
}

static unsigned char called_count;
EXPORT void CALL UpdateScreen(void)
{
    if (called_count < cfg[14])
    {
        ++called_count;
        return;
    }
    called_count = 0x00;

    device_context = wglGetCurrentDC();
    render_context = wglGetCurrentContext();
    if (device_context == NULL || render_context == NULL)
        init_GL_context(gfx.hWnd);

    rdp_update();
    if (cfg[23] & 0x04)
        MessageBox(NULL, "Updated screen.\nPaused.", "Frame Step", MB_OK);
    return;
}

EXPORT void CALL ViStatusChanged(void)
{
    char message[] = "New VI_CONTROL_REG:  0x00000000";
    static const char digits[16] = {
        '0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F'
    };
    const unsigned long status = *GET_GFX_INFO(VI_STATUS_REG) & 0xFFFFFFFF;

    message[23] = digits[(status >> 28) & 0xF];
    message[24] = digits[(status >> 24) & 0xF];
    message[25] = digits[(status >> 20) & 0xF];
    message[26] = digits[(status >> 16) & 0xF];
    message[27] = digits[(status >> 12) & 0xF];
    message[28] = digits[(status >>  8) & 0xF];
    message[29] = digits[(status >>  4) & 0xF];
    message[30] = digits[(status >>  0) & 0xF];

    DisplayInStatusPanel(message);
    sync = TRUE;
    return;
}

EXPORT void CALL ViWidthChanged(void)
{
    GLenum cleared;
    char message[] = "New VI_H_WIDTH_REG:  0x00000000";
    static const char digits[16] = {
        '0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F'
    };
    const unsigned long width = *GET_GFX_INFO(VI_WIDTH_REG) & 0xFFFFFFFF;

    message[23] = digits[(width >> 28) & 0xF];
    message[24] = digits[(width >> 24) & 0xF];
    message[25] = digits[(width >> 20) & 0xF];
    message[26] = digits[(width >> 16) & 0xF];
    message[27] = digits[(width >> 12) & 0xF];
    message[28] = digits[(width >>  8) & 0xF];
    message[29] = digits[(width >>  4) & 0xF];
    message[30] = digits[(width >>  0) & 0xF];
    DisplayInStatusPanel(message);

    device_context = wglGetCurrentDC();
    render_context = wglGetCurrentContext();
    if (device_context == NULL || render_context == NULL)
        init_GL_context(gfx.hWnd);

    glClear(GL_COLOR_BUFFER_BIT);
    cleared = glGetError();
    if (cleared != GL_NO_ERROR)
        DisplayGLError("Failed to clear screen.", cleared);

    sync = TRUE; /* Synchronize viewport width/height at next VI update. */
    return;
}

EXPORT void CALL FBWrite(DWORD addr, DWORD size)
{
    return;
}

EXPORT void CALL FBWList(FrameBufferModifyEntry *plist, DWORD size)
{
}

EXPORT void CALL FBRead(DWORD addr)
{
}

EXPORT void CALL FBGetFrameBufferInfo(void *pinfo)
{
}

/*
 * using the NTSC-typical SMPTE standard of 75% color intensity
 */
#define CHAN_OFF    (GLfloat)(0./4.)
#define CHAN_ON     (GLfloat)(3./4.)

static const GLfloat colors[8][4] = {
    { CHAN_ON , CHAN_ON , CHAN_ON , 1.f, },
    { CHAN_ON , CHAN_ON , CHAN_OFF, 1.f, },
    { CHAN_OFF, CHAN_ON , CHAN_ON , 1.f, },
    { CHAN_OFF, CHAN_ON , CHAN_OFF, 1.f, }, /* highest luminance:  green */
    { CHAN_ON , CHAN_OFF, CHAN_ON , 1.f, }, /* lower luminance w/o green */
    { CHAN_ON , CHAN_OFF, CHAN_OFF, 1.f, },
    { CHAN_OFF, CHAN_OFF, CHAN_ON , 1.f, },
    { CHAN_OFF, CHAN_OFF, CHAN_OFF, 1.f, },
};
static void draw_test_screen(void)
{
    GLdouble coordinates[4];
    const GLdouble * vertex;
    GLenum error;
    register int i;
    const GLdouble increment = +2./7.; /* change to 2/8 if 8 bars */

    vertex = (const GLdouble *)(coordinates);
    glClearColor(.075f, .075f, .075f, 1.0f);
    glClear(GL_COLOR_BUFFER_BIT);

    coordinates[0] = 0./3. - 1.;
    coordinates[1] = 2./3. - 1.;
    coordinates[2] = coordinates[0] + increment;
    coordinates[3] = 1.;
    for (i = 0; i < 8 - 1; i++)
    {
        glColor3fv(colors[i]);
        glRectdv(vertex + 0, vertex + 2);
        coordinates[0] += increment;
        coordinates[2] += increment;
    }

    coordinates[0] = 0./3. - 1.;
    coordinates[1] = 2./4. - 1.;
    coordinates[2] = coordinates[0] + increment;
    coordinates[3] = 2./3. - 1.;
    for (i = 0; i < 4; i++)
    {
        glColor3fv(colors[6 - 2*i]);
        glRectdv(vertex + 0, vertex + 2);
        coordinates[0] += 2 * increment;
        coordinates[2] += 2 * increment;
    }

    coordinates[0] = 0./3. - 1.;
    coordinates[1] = 0./3. - 1.;
    coordinates[2] = coordinates[0] + 5./28.*2.; /* approximate?? */
    coordinates[3] = coordinates[1] + 2./4.;

    glColor3f(0.f, .125f, .295f); /* colors approximate?? */
    glRectdv(vertex + 0, vertex + 2);

    coordinates[0] += 10. / 28.;
    coordinates[2] += 10. / 28.;
    glColor3f(1.f, 1.f, 1.f);
    glRectdv(vertex + 0, vertex + 2);

    coordinates[0] += 10. / 28.;
    coordinates[2] += 10. / 28.;
    glColor3f(.195f, 0.f, .415f); /* colors approximate?? */
    glRectdv(vertex + 0, vertex + 2);

    error = glGetError();
    if (error != GL_NO_ERROR)
        DisplayGLError("Failed to draw bars test pattern.", error);
    return;
}

static NOINLINE BOOL init_GL_context(HWND hWnd)
{
    int pixel_format_enum, pixel_format_old;
    int formats;
    PIXELFORMATDESCRIPTOR test;
    HGLRC current_RC;
    HDC current_DC;
    GLenum error;
    BOOL pass;
    RECT status_bar = { 0 };

    device_context = GetDC(hWnd);
    if (device_context == NULL)
    {
        DisplayError("Failed to get device context from render window.");
        return FALSE;
    }

    pixel_format_enum = ChoosePixelFormat(device_context, &pixel_format);
    if (pixel_format_enum == 0)
    {
        DisplayError("No suitable pixel format detected on this system.");
        return FALSE;
    }

    pixel_format_old = GetPixelFormat(device_context);
    if (pixel_format_old != 0 && pixel_format_enum != pixel_format_old)
        pixel_format_enum = pixel_format_old;

    pass = SetPixelFormat(device_context, pixel_format_enum, &pixel_format);
    if (pass == FALSE)
    {
        DisplayError("Failed to set detected pixel format.");
        return FALSE;
    }

    render_context = wglCreateContext(device_context);
    if (render_context == NULL)
    {
        DisplayError("Failed to get OpenGL render context from DC.");
        return FALSE;
    }

    pass = wglMakeCurrent(device_context, render_context);
    if (pass == FALSE)
    {
        DisplayError("Failed to set valid render context.");
        return FALSE;
    }

    current_RC = wglGetCurrentContext();
    current_DC = wglGetCurrentDC();
    if (current_RC != render_context || current_DC != device_context)
        DisplayWarning("OpenGL context state mismatches?");

    formats = GetPixelFormat(device_context);
    formats = DescribePixelFormat(
        device_context, formats, sizeof(PIXELFORMATDESCRIPTOR), &test);
    double_buffering = (test.dwFlags & PFD_DOUBLEBUFFER) ? GL_TRUE : GL_FALSE;

    if (formats == 0) /* either no valid pixel formats or failed call */
        DisplayWarning("Unable to count possible pixel formats?");
    else if (test.dwFlags & PFD_GENERIC_FORMAT)
        DisplayWarning(
            "Pixel format not accelerated!\nExpect horrible performance.");

    screen_resize(640, 480);
    if (gfx.hStatusBar != NULL)
        GetClientRect(gfx.hStatusBar, &status_bar);
    glViewport(status_bar.left, status_bar.bottom, 640, 480);

    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();

    glColor3d(0.0, 1.0, 0.0);
    glRasterPos2d(-1., +1.);
    glColor3d(1.0, 1.0, 1.0);

    glDisable(GL_DEPTH_TEST);
    glDisable(GL_CULL_FACE);
    glDisable(GL_BLEND);
    glDisable(GL_SCISSOR_TEST);

    glClearColor(0.f, 0.f, 0.f, 0.f);
    glClearDepth(0.);
    glClearStencil(0);
    glClearAccum(0.f, 0.f, 0.f, 0.f);

    glDrawBuffer(GL_FRONT_AND_BACK);
    glClear(buffers_mask | GL_ACCUM_BUFFER_BIT);
    glDrawBuffer(double_buffering ? GL_BACK : GL_FRONT);
    DisplayInStatusPanel("Waiting for video input...");

    glFinish();
    draw_test_screen();
    glColor4f(1.f, 1.f, 1.f, 1.f);
    glClearColor(.5f, .5f, .5f, .5f);

    pass = swap_buffers();
    if (pass == 0)
        DisplayError("Swapping buffers seems to fail.");

    glEnable(GL_TEXTURE_2D);
    glDeleteTextures(1, &name);
    glGenTextures(1, &name);
    glBindTexture(GL_TEXTURE_2D, name);

    pitchindwords = PRESCALE_WIDTH / 1;
    error = glGetError();
    if (error != GL_NO_ERROR)
    {
        DisplayGLError("Failed to test OpenGL context.", error);
        return FALSE;
    }
    return TRUE;
}
